import pandas as pd  
import pickle 
from decision_company import read_csv_file, logical_or, filter_by_condition, fetch_index, convert_to_list, fetch_column

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  

# Create conditions  
condition1 = fetch_column(high_credit_long_duration, 'employment') == '4<=X<7'  
condition2 = fetch_column(high_credit_long_duration, 'employment') == '>=7'  
  
# Perform logical OR operation  
final_condition = logical_or(condition1, condition2)  
  
# Filter the clients with stable employment (4 years or more)  
stable_employment = filter_by_condition(high_credit_long_duration, final_condition)  
  
# Extract the client IDs  
result = fetch_index(stable_employment)  
  
# Convert the result to a list  
result_list = convert_to_list(result)  
  
print(result_list)  
pickle.dump(result_list,open("./ref_result/result_list_4.pkl","wb"))